create or replace package body tbicds.PCK_PROVIDER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Get provider recordset
*/
   procedure GetProviderRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_vDIMSID          in varchar2,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor)
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select t.provider_id, t.name '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where t.dims_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id '
                || 'and r.user_type in (1,2) '
                || 'order by t.name ';
      --open recordset
      open rs for v_vSQL using pi_vDIMSID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PROVIDER.GetProviderRS(): ' || sqlErrm;
   end;

end;
/

